#include "GetObjects.js"
#include "GetDistance.js"

function DoShell()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowFaces();
	objectpicker.allowBReps();
	
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;

	var factory = moi.command.createFactory( 'shell' );
	factory.setInput( 0, objects );

	// Bind the solidflip check box factory's flip input.
	factory.disableUpdate( true );
	moi.ui.bindUIToInput( 'direction', 'value', factory.getInput(2) );
	factory.disableUpdate( false );
	
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectPrompt' );
	moi.ui.showUI( 'SolidDistancePrompt' );
	moi.ui.showUI( 'SolidOptions' );
	moi.ui.endUIUpdate();
	
	if ( !GetDistance( factory, 1, 'soliddistanceinput' ) )
		return;
	
	factory.commit();
}

DoShell();
